################################################################################
################################################################################
#
#			Democratic Effect of DD
#
#			September, 2015
#			Lucas Leemann and Fabio Wasserfallen
#			l.leemann@ucl.ac.uk & wasserfallen@ipz.uzh.ch
#			
################################################################################
################################################################################
			
			
###
# Thank you for your interest in our paper. This R file will call all other files
# and replicate all results we present in the paper and the appendix.
###
			
# write the path to the replication file here			
your_path <- "/..../Replication archive DEoDD"
setwd(your_path)

################################################################################
#! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! #
#	To replicate the exact same results as presented in the manuscript, you will
#	have to use version 1.1.7 of the lme4 package.
#	If you want to use "lme4_1.1.-7" you can follow these instructions here. The 
#	code will at the end automatically install the most current version of lme4.
# 	Note: We commented out all "install.pack.." commands to avoid accidental 
# 	execution of a command.

# !

# For "Mac OSX - Snow Leopard" run this command
	# install.packages("https://cran.r-project.org/bin/macosx/contrib/r-oldrel/lme4_1.1-7.tgz", repos=NULL, type="binary")

# For "Mac OSX - Maverick" you can directly compile the source file (requires to have Xcode installed - see: https://developer.apple.com/xcode/downloads/) 
# with Xcode you can run the following command:
	# install.packages("http://cran.r-project.org/src/contrib/Archive/lme4/lme4_1.1-7.tar.gz", repos=NULL, type="source")

# For Windows you can use this command:
	# install.packages("https://cran.r-project.org/bin/windows/contrib/3.0/lme4_1.1-7.zip", repos=NULL, type="binary")

# If you use the most up to date lme4 package (currently 1.1.9) you can still 
# estimate all models, but will see sometimes numerically slightly different values.
# No changes to substantive results or significance levels.
#! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! #
################################################################################

# This code will determine which packages are already installed on your 
# computer and only dowload the ones that are missing (this code will NOT update
# your packages)
source("LoadDownload.R")

# Create the final datasets
source("Generate Preferences CITIZENS.R")
source("Generate Preferences GOVERNMENT.R")
source("Data Set Up.R")

# Run Analysis
source("explaining congruence.R")

# add some plots
source("Plot 1.R")
source("Plot 4.R")
source("Plot 5.R")